/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.TimeParameterInterface;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public abstract class TimeProtectionParameter
extends ProtectionParameter
implements TimeParameterInterface {
    static final long serialVersionUID = 0L;
    private int timeProtectionParameterSerializedDataVersion = 2;
    protected Timer fTimer;
    protected int fState;
    protected static final int READY = 0;
    protected static final int WAITING = 1;
    protected static final int RUNNING = 2;

    public TimeProtectionParameter() {
    }

    public TimeProtectionParameter(Block block) {
        super(block);
        this.fParameter = 2;
        this.fData = 1;
        this.fAllocatedTimer = 1;
    }

    public String calculateCurrentParameterText() {
        return this.getTimer().getPassedTime().getTimeAsString();
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        String superText = super.getParameterText();
        if (superText.length() > 0) {
            result.append(superText);
            result.append("\n");
        }
        result.append(this.getTimer().getParamTime().getParameterText());
        result.append(this.getProtectionSign());
        return result.toString();
    }

    public Timer getTimer() {
        if (this.fTimer == null) {
            this.setTimer(new Timer());
        }
        return this.fTimer;
    }

    public void setTimer(Timer newTimer) {
        this.fTimer = newTimer;
    }

    public TimeValueProperties getParamTime() {
        TimeValueProperties props = this.getTimer().getParamTimeProperties();
        props.setParameter(this);
        return props;
    }

    public int getTimeBase() {
        return Util.getTimeBase(this.getTimer().getParamTime());
    }

    public void setTimeBase(int value) {
        Util.setTimeBase(this.getTimer().getParamTime(), value);
    }

    public void setParamTime(TimeValueProperties newTime) {
        this.getTimer().setParamTimeProperties(newTime);
    }

    public TimeUnit getPassedTime() {
        return this.getTimer().getPassedTime();
    }

    public TimeUnit getRestTime() {
        if (this.fState == 1 || this.fState == 2) {
            return this.getTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getTimer().getParamTime().getUnitKey());
    }

    public void setPassedTime(TimeUnit newTime) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setPassedTime is not supported");
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTimer = (Timer)dr.readStorable();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.timeProtectionParameterSerializedDataVersion == 1) {
            this.setParameterNameKeys();
            this.timeProtectionParameterSerializedDataVersion = 2;
        }
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getTimer().init(interpreter);
        this.getTimer().init(interpreter);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.getTimer().reset();
            this.fState = 0;
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fTimer);
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean available = super.isAvailable(hw, errorList);
        TimeUnit[] availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
        if (!(this.getTimer().isTimerConvertibleTo(availableTimeUnits) || this.getTimer().getParamTime().getClass() == Reference.class && hw.supports("referenceFunction"))) {
            errorList.add(new ErrorInfo(this, "error.convert.timerNotConvertible", hw));
            available = false;
        }
        if (this.getRemanenceAvailable() && !hw.supports("REMTimer") && this.getRemanenceObject().getRemanence()) {
            errorList.add(new ErrorInfo(this, "error.convert.timerWithREM", hw));
            available = false;
        }
        return available;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware hardware = (Hardware)hardwareChangedEvent.getNewValue();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hardware.getProperty("availableTimeUnits");
        this.getTimer().convertTimerTo(availableTimeUnits);
    }
}

